﻿/*	VERSION:  1.9
1.9			invalid functions now return undefined
1.8			apply()  now uses thisScope as this

DEPENDENCIES:
	evalPath.as
		getImpliedValue.as
		resolveContainer.as

USAGE:
	#include "functions/evalpath.as"
	path = "myObj.subObj.myVar";
	result = evalpath( path, "RAM", "_this" );

DESCRIPTION:
	Get the value of the specified variable.
	(Returns the value of a variable specified by a string path)
	
	If (parameters,are,present) then the resulting path will be invoked as a function with the parameters passed to it as implied values  ("false" => false,  "14" => 14,  "string" => "string",  "undefined" => undefined,  etc...)
	... then the result of that function-call will be returned by evalPath()
	
	
PARAMETERS: 
	inputPath								The input-path being resolved into a variable-reference or the value contained within the specified variable
	defaultContainer_str		If the path starts with an invalid parent,  replace it with this string.		(invalid means that it's not a global object,  _root,  or  "this")		This string should not include a .
	thisName								If the path starts with "this." replace it with this string  (preserves the .)  This string should not include a .
*/
#include "getImpliedValue.as"
#include "resolveContainer.as"
function evalPath( inputPath, defaultContainer_str, thisName )
{
	var thisScope = this;
	var thisName = thisName || "this";
	if( typeof(inputPath) == "string" )
	{// if:  input is a string
		// resolve defaultContainer_str
		if(!defaultContainer_str)
			var defaultContainer_str = (typeof(thisName) === "string") ? thisName : "this";		// use the variable if it's a string
		// get assumed container
		var endAt = inputPath.indexOf(".");
		// if there is no sub-path, assume the entire path is the container
		if(endAt==-1)
			endAt = inputPath.length;
		var container_str = inputPath.substr(0, endAt);
		// verify that it's a container
		var container_str = resolveContainerStr( container_str, thisName );
		// if:  it's not a container,  then use defaultContainer_str or "this"
		if( !container_str ){
			var container_str = defaultContainer_str;
			endAt = -1;
		}
		// eval the path
		var theRest = inputPath.substr(endAt+1);
		var fullPath = (theRest) ? container_str+"."+theRest : container_str;
		
		// handle functions
		var paramStart = fullPath.indexOf("(");
		if(paramStart != -1)
		{// if:  result is a function
			var paramEnd = fullPath.indexOf(")", paramStart+1);
			var param = fullPath.substring(paramStart+1, paramEnd);
			//var param = getImpliedValue(param);
			var functionPath = fullPath.substr(0,paramStart);
			var thisFunction = eval(functionPath);
			
			var param_array = String(param).split(",");
			for(var i=0; i<param_array.length; i++)
				param_array[i] = getImpliedValue(param_array[i]);
			// // 	params that are strings cannot contain:		[ ] ( ) ,
			// // 	"" are not used in parameters, so be careful with spaces in all params, regardless of type
			// do function call
			var output = undefined;
			if(thisFunction instanceof Function)
				output = thisFunction.apply( thisScope, param_array );
		}// if:  result is a function
		
		else
		{// if:  result is NOT a function
			// handle non-functions
			var output = eval(fullPath);
		}// if:  result is NOT a function
	}// if:  input is a string
	else
	{// if:  input is NOT a string
		var output = inputPath;
	}// if:  input is NOT a string
	// return the result
	return output;
}// evalPath()